// Function to save form data
function saveLogoBriefInformationForm(event) {
  event.preventDefault();

  const logo_Name = document.getElementById("logoname").value;
  const tag_Line = document.getElementById("tagline").value;
  const business_Description = document.getElementById(
    "businessdescription"
  ).value;
  const other_Colors = document.getElementById("othercolors").value;
  const leaveTo_Designer = document.getElementById("leavetodesigner").checked;
  const logo_Ideas = document.getElementById("logoideas").value;
  const package_name = document
    .querySelector("#logoform")
    .getAttribute("data-package-name");

  localStorage.setItem("logoName", logo_Name);
  localStorage.setItem("tagLine", tag_Line);
  localStorage.setItem("businessDescription", business_Description);
  localStorage.setItem("otherColors", other_Colors);
  localStorage.setItem("leaveToDesigner", leaveTo_Designer);
  localStorage.setItem("logoIdeas", logo_Ideas);
  // Save package name

  // Create a FormData object to send data via POST
  const formData = new FormData();
  formData.append("logoname", logo_Name);
  formData.append("tagline", tag_Line);
  formData.append("businessdescription", business_Description);
  formData.append("othercolors", other_Colors);
  formData.append("leavetodesigner", leaveTo_Designer);
  formData.append("logoideas", logo_Ideas); // Include package name
  formData.append("packageName", package_name);
  // Send data to PHP endpoint
  fetch("email_handler_logobrief.php", {
    method: "POST",
    body: formData,
  })
    .then((response) => response.text())
    .then((data) => {
      console.log("Server Response:", data);
      // alert("Form submitted and email sent successfully!");
      // window.location.href = "logo-brief-checkout-page.html";
    })
    .catch((error) => {
      console.error("Error submitting form:", error);
      // alert("Failed to send form. Please try again.");
    });
}

const packagesName = ["lite", "surge", "excel", "the best"];
const packageDetails = {};

packagesName.forEach((name) => {
  packageDetails[name] = {
    logoName: logo_Name,
    tagLine: tag_Line,
    businessDescription: business_Description,
    otherColors: other_Colors,
    leaveToDesigner: leaveTo_Designer,
    logoIdeas: logo_Ideas,
  };
});
localStorage.setItem("packageDetails", JSON.stringify(packageDetails));

// saveSelectedColors();

const packagestoreddata = JSON.parse(localStorage.getItem("packageDetails"));
sendPackageDetailsEmail(packagestoreddata);

function populateLogoBriefInformationForm() {
  const logoName = localStorage.getItem("logoName");
  const tagLine = localStorage.getItem("tagLine");
  const businessDescription = localStorage.getItem("businessDescription");
  const otherColors = localStorage.getItem("otherColors");
  const leaveToDesigner = localStorage.getItem("leaveToDesigner");
  const logoIdeas = localStorage.getItem("logoIdeas");

  const logoNameEl = document.getElementById("logoname");
  const tagLineEl = document.getElementById("tagline");
  const businessDescriptionEl = document.getElementById("businessdescription");
  const otherColorsEl = document.getElementById("othercolors");
  const leaveToDesignerEl = document.getElementById("leavetodesigner");
  const logoIdeasEl = document.getElementById("logoideas");

  logoNameEl.value = logoName;
  tagLineEl.value = tagLine;
  businessDescriptionEl.value = businessDescription;
  otherColorsEl.value = otherColors;
  leaveToDesignerEl.checked = leaveToDesigner === "true";
  logoIdeasEl.value = logoIdeas;

  // restoreSelectedColors();
}

// function saveSelectedColors() {
//   const colorBoxes = document.querySelectorAll(".color-box");
//   const selectedColors = [];

//   colorBoxes.forEach((box) => {
//     if (box.classList.contains("selected")) {
//       selectedColors.push(box.style.backgroundColor);
//     }
//   });

//   localStorage.setItem("selectedColors", JSON.stringify(selectedColors));
// }

// function restoreSelectedColors() {
//   const savedColors = JSON.parse(localStorage.getItem("selectedColors")) || [];
//   const colorBoxes = document.querySelectorAll(".color-box");

//   colorBoxes.forEach((box) => {
//     if (savedColors.includes(box.style.backgroundColor)) {
//       box.classList.add("selected");
//     }
//   });
// }

// document.addEventListener("DOMContentLoaded", function () {
//   populateLogoBriefInformationForm();

//   const colorBoxes = document.querySelectorAll(".color-box");
//   colorBoxes.forEach((box) => {
//     box.addEventListener("click", function () {
//       this.classList.toggle("selected");
//       saveSelectedColors();
//     });
//   });
//   restoreSelectedColors();
// });
