function saveContactInformationForm(event) {
  event.preventDefault();

  const first_name = document.getElementById("firstname").value;
  const last_name = document.getElementById("lastname").value;
  const company_name = document.getElementById("company").value;
  const phone_number = document.getElementById("phone").value;
  const email = document.getElementById("email").value;
  const package_name =
    document
      .querySelector(".form-container")
      ?.getAttribute("data-package-name") || "";

  console.log("Package Name:", package_name);

  localStorage.setItem("firstName", first_name);
  localStorage.setItem("lastName", last_name);
  localStorage.setItem("companyName", company_name);
  localStorage.setItem("phoneNumber", phone_number);
  localStorage.setItem("email", email);
  localStorage.setItem("packageName", package_name); // Save package name

  // Create a FormData object to send data via POST
  const formData = new FormData();
  formData.append("firstname", first_name);
  formData.append("lastname", last_name);
  formData.append("company", company_name);
  formData.append("phone", phone_number);
  formData.append("email", email);
  formData.append("packageName", package_name); // Include package name

  // Send data to PHP endpoint
  fetch("email_handler.php", {
    method: "POST",
    body: formData,
  })
    .then((response) => response.text())
    .then((data) => {
      console.log("Server Response:", data);
      // alert("Form submitted and email sent successfully!");
      // window.location.href = "logo-brief-checkout-page.html";
    })
    .catch((error) => {
      console.error("Error submitting form:", error);
      // alert("Failed to send form. Please try again.");
    });
}

function populateContactInformationForm() {
  const firstName = localStorage.getItem("firstName");
  const lastName = localStorage.getItem("lastName");
  const companyName = localStorage.getItem("companyName");
  const number = localStorage.getItem("phoneNumber");
  const email = localStorage.getItem("email");

  const firstNameEl = document.getElementById("firstname");
  const lastNameEl = document.getElementById("lastname");
  const companyNameEl = document.getElementById("company");
  const phoneEl = document.getElementById("phone");
  const emailEl = document.getElementById("email");

  firstNameEl.value = firstName;
  lastNameEl.value = lastName;
  companyNameEl.value = companyName;
  phoneEl.value = number;
  emailEl.value = email;
}
